/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.HLE.TPointer;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.util.Utilities;

public class PspString {
    protected String string;
    protected int address;
    protected int maxLength;
    protected boolean canBeNull;

    public PspString(int address) {
        this.string = null;
        this.address = address;
        this.maxLength = MemoryMap.SIZE_RAM;
    }

    public PspString(int address, int maxLength) {
        this.string = null;
        this.address = address;
        this.maxLength = maxLength;
    }

    public PspString(int address, int maxLength, boolean canBeNull) {
        this.string = null;
        this.address = address;
        this.maxLength = maxLength;
        this.canBeNull = canBeNull;
    }

    public PspString(String string) {
        this.address = 0x8800000;
        this.string = string;
    }

    public PspString(TPointer pointer) {
        this.string = null;
        this.address = pointer.getAddress();
        this.maxLength = MemoryMap.SIZE_RAM;
    }

    public PspString(TPointer pointer, int offset) {
        this.string = null;
        this.address = pointer.getAddress() + offset;
        this.maxLength = MemoryMap.SIZE_RAM;
    }

    public String getString() {
        if (this.string == null) {
            this.string = this.canBeNull && this.isNull() ? "" : Utilities.readStringNZ(this.address, this.maxLength);
        }
        return this.string;
    }

    public int getAddress() {
        return this.address;
    }

    public TPointer getPointer() {
        return new TPointer(Memory.getInstance(), this.address);
    }

    public boolean isNull() {
        return this.address == 0;
    }

    public boolean isNotNull() {
        return this.address != 0;
    }

    public String toString() {
        return String.format("0x%08X('%s')", this.getAddress(), this.getString());
    }

    public boolean equals(String s) {
        if (s == null) {
            return this.isNull();
        }
        if (this.isNull()) {
            return false;
        }
        return s.equals(this.getString());
    }
}

